/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIESIMGMT_H
#define PCIESIMGMT_H

const AgtValueT PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY3 = 256; // copy from devpcieintdefs.h

class CPCIESiMgmt
{
public: 

  CPCIESiMgmt();
  ~CPCIESiMgmt();

  // Send immediate
  void SiSend( const AgtPortHandleT& portHandle );
  void SiDefaultSet( const AgtPortHandleT& portHandle );

  void SiReqPropWrite( const AgtPortHandleT& portHandle, const EPCIESi& prop, const UInt32& val );
  UInt32 SiReqPropRead( const AgtPortHandleT& portHandle, const EPCIESi& prop );
  UInt32 SiCompPropRead( const AgtPortHandleT& portHandle, const EPCIESi& prop );
  void SiCompPropWrite( const AgtPortHandleT& portHandle, const EPCIESi& prop, const UInt32& val );

  UInt32 SiCompPyldGet( const AgtPortHandleT& portHandle, const UInt8& offset );
  void SiCompPyldByteGet( const AgtPortHandleT& portHandle, UInt32 numBytes, UInt8* theData );

  UInt32 SiReqPyldGet( const AgtPortHandleT& portHandle, const UInt8& offset );
  void SiReqPyldByteGet( const AgtPortHandleT& portHandle, UInt32 numBytes, UInt8* theData );

  void SiReqPyldSet( const AgtPortHandleT& portHandle, const UInt8& offset, const UInt32& val );
  void SiReqPyldByteSet( const AgtPortHandleT& portHandle, UInt32 numBytes, UInt8* theData );

  UInt32 SiStatusGet( const AgtPortHandleT& portHandle, const EPCIESiStatus& siStatus );

private:
  void SiPropWrite( const AgtPortHandleT& portHandle, const bool& req, const EPCIESi& prop, const UInt32& val );
  UInt32 SiPropRead( const AgtPortHandleT& portHandle, const bool& req, const EPCIESi& prop );

  UInt32 SiPyldGet( const AgtPortHandleT& portHandle, const bool& req, const UInt8& offset );
  void SiPyldSet( const AgtPortHandleT& portHandle, const bool& req, const UInt8& offset, const UInt32& val );

  void SiPyldByteGet( const AgtPortHandleT& portHandle, const bool& req, UInt32 numBytes, UInt8* theData );
  void SiPyldByteSet( const AgtPortHandleT& portHandle, const bool& req, UInt32 numBytes, UInt8* theData );

  bool mSuccessfullySent[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY3];
};

#endif /* PCIESIMGMT_H */